/*
 * Decompiled with CFR 0.152.
 */
package com.chronapp.porter.client.connection;

import com.chronapp.porter.client.connection.PorterAPIClient;
import com.chronapp.porter.common.Row;
import com.chronapp.porter.config.ClientConfig;
import com.chronapp.porter.download.DownloadDataHandler;
import java.math.BigInteger;
import java.util.List;
import java.util.UUID;

public class RestApiDownloader {
    private final ClientConfig config;
    private final DownloadDataHandler downloader;
    private final String api;
    private final UUID uuid;

    public RestApiDownloader(ClientConfig config, UUID uuid, DownloadDataHandler downloader, String api) {
        this.config = config;
        this.downloader = downloader;
        this.api = api;
        this.uuid = uuid;
    }

    public void downloadList(PorterAPIClient client) {
        int max = this.config.getMaxRows();
        int total = max + 1;
        for (int offset = 0; offset < total; offset += max) {
            DownloadResponse r = client.download(this.api, offset, max, this.uuid);
            this.downloader.handle(r.data(), r.logId());
            total = r.total();
        }
    }

    public record DownloadResponse(List<Row> data, int total, BigInteger logId) {
    }
}

