/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core.interception.jaxrs;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import jakarta.ws.rs.ext.ReaderInterceptor;
import jakarta.ws.rs.ext.ReaderInterceptorContext;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.resteasy_jaxrs.i18n.Messages;
import org.jboss.resteasy.spi.ResteasyProviderFactory;
import org.jboss.resteasy.tracing.InterceptorTimestampPair;
import org.jboss.resteasy.tracing.RESTEasyTracingLogger;

public abstract class AbstractReaderInterceptorContext
implements ReaderInterceptorContext {
    protected RESTEasyTracingLogger tracingLogger;
    private InterceptorTimestampPair<ReaderInterceptor> lastTracedInterceptor;
    protected ReaderInterceptor[] interceptors;
    protected ResteasyProviderFactory providerFactory;
    protected Class type;
    protected Type genericType;
    protected Annotation[] annotations;
    protected MediaType mediaType;
    protected MultivaluedMap<String, String> headers;
    protected InputStream inputStream;
    protected int index = 0;

    @Deprecated
    public AbstractReaderInterceptorContext(MediaType mediaType, ResteasyProviderFactory providerFactory, Annotation[] annotations, ReaderInterceptor[] interceptors, MultivaluedMap<String, String> headers, Type genericType, Class type, InputStream inputStream) {
        this.mediaType = mediaType;
        this.annotations = annotations;
        this.interceptors = interceptors;
        this.headers = headers;
        this.genericType = genericType;
        this.type = type;
        this.inputStream = inputStream;
        this.providerFactory = providerFactory;
        this.tracingLogger = RESTEasyTracingLogger.empty();
    }

    public AbstractReaderInterceptorContext(MediaType mediaType, ResteasyProviderFactory providerFactory, Annotation[] annotations, ReaderInterceptor[] interceptors, MultivaluedMap<String, String> headers, Type genericType, Class type, InputStream inputStream, RESTEasyTracingLogger logger2) {
        this.mediaType = mediaType;
        this.annotations = annotations;
        this.interceptors = interceptors;
        this.headers = headers;
        this.genericType = genericType;
        this.type = type;
        this.inputStream = inputStream;
        this.providerFactory = providerFactory;
        this.tracingLogger = logger2;
        if (logger2 == null) {
            this.tracingLogger = RESTEasyTracingLogger.empty();
        }
    }

    @Override
    public Object proceed() throws IOException {
        LogMessages.LOGGER.debugf("Interceptor Context: %s,  Method : proceed", (Object)this.getClass().getName());
        if (this.interceptors == null || this.index >= this.interceptors.length) {
            MessageBodyReader reader = this.getReader();
            if (reader != null) {
                this.tracingLogger.log("MBR_READ_FROM", reader.getClass().getName());
                LogMessages.LOGGER.debugf("MessageBodyReader: %s", (Object)reader.getClass().getName());
            }
            return this.readFrom(reader);
        }
        LogMessages.LOGGER.debugf("ReaderInterceptor: %s", (Object)this.interceptors[this.index].getClass().getName());
        int x = this.index;
        this.traceBefore(this.interceptors[x]);
        try {
            Object object = this.interceptors[this.index++].aroundReadFrom(this);
            return object;
        }
        finally {
            this.traceAfter(this.interceptors[x]);
        }
    }

    protected Object readFrom(MessageBodyReader reader) throws IOException {
        return reader.readFrom(this.type, this.genericType, this.annotations, this.mediaType, this.headers, this.inputStream);
    }

    protected final void traceBefore(ReaderInterceptor interceptor) {
        if (this.tracingLogger.isLogEnabled("RI_BEFORE")) {
            if (this.lastTracedInterceptor != null && interceptor != null) {
                this.tracingLogger.logDuration("RI_BEFORE", this.lastTracedInterceptor.getTimestamp(), this.lastTracedInterceptor.getInterceptor());
            }
            this.lastTracedInterceptor = new InterceptorTimestampPair<ReaderInterceptor>(interceptor, System.nanoTime());
        }
    }

    protected final void traceAfter(ReaderInterceptor interceptor) {
        if (this.tracingLogger.isLogEnabled("RI_AFTER")) {
            if (this.lastTracedInterceptor != null && this.lastTracedInterceptor.getInterceptor() != null) {
                this.tracingLogger.logDuration("RI_AFTER", this.lastTracedInterceptor.getTimestamp(), interceptor);
            }
            this.lastTracedInterceptor = new InterceptorTimestampPair<ReaderInterceptor>(interceptor, System.nanoTime());
        }
    }

    protected MessageBodyReader getReader() {
        MessageBodyReader reader;
        MediaType mediaType = this.mediaType;
        if (this.getHeaders() != null && this.getHeaders().getFirst("Content-Type") == null && mediaType.isWildcardType()) {
            mediaType = MediaType.APPLICATION_OCTET_STREAM_TYPE;
        }
        if ((reader = this.resolveReader(mediaType)) == null) {
            this.throwReaderNotFound();
        }
        return reader;
    }

    protected abstract MessageBodyReader resolveReader(MediaType var1);

    protected abstract void throwReaderNotFound();

    @Override
    public InputStream getInputStream() {
        return this.inputStream;
    }

    @Override
    public void setInputStream(InputStream is) {
        this.inputStream = is;
    }

    @Override
    public MultivaluedMap<String, String> getHeaders() {
        return this.headers;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public void setAnnotations(Annotation[] annotations) {
        if (annotations == null) {
            throw new NullPointerException(Messages.MESSAGES.annotationsParamNull());
        }
        this.annotations = annotations;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    @Override
    public Type getGenericType() {
        return this.genericType;
    }

    @Override
    public void setGenericType(Type genericType) {
        this.genericType = genericType;
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }

    public Object getProcessedInterceptorCount() {
        return this.index;
    }
}

